	function [Z, KI, RL] = RICHARDS(Num, Den)
	
	% 	Computes the characteristic impedances in a Richards' structure   
	%	consisting of cascaded lossless comensurate transmission lines 
	%	for an impedance Z = Num/Den, where Num and Den are polynomials 
	%	in S, where S is Richards' variable. For example, Num = [ 1 2 3]
	%	correspond to Num = 1 + 2S + 3S^2.
	%	The last transmission line is either open-circuited, 
	%	short-circuited, or resistively terminated.
	%
	%	The vector Z contains the characteristic impedances for the  
	%	transmission lines and a possible resistive termination, RL, 
	%	is given separately.	 
	%	KI is a vector used by LADDER_2_H that defines the two-ports.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 			Lars Wanhammar, 2008-11-17
	% 	Modified by: 	 	
	%	Copyright:			by authors - not released for commercial use
	% 	Version:			1 
	% 	Known bugs:	 
	% 	Report bugs to:		Wanhammar@gmail.com
	
	Z = []; 
	a = Num;
	b = Den;
	for k = 1:length(b)
		Z0 = sum(a)/sum(b);
		for j = 2:length(b)
			a(j) = a(j) - Z0*b(j-1);
			b(j) = b(j) - a(j-1)/Z0;
		end
		if k == length(b)
			RL = abs(Z0);
			if RL < 10^-6, RL = 0; end
			if RL > 10^6, RL = inf; end
		else
			Z = [Z, Z0];
			KI(k) = 6;
		end
	end
